% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp.airwls.glmfit}
\alias{cpp.airwls.glmfit}
\title{Fisher scoring algorithm for GLMs}
\usage{
cpp.airwls.glmfit(
  beta,
  y,
  X,
  familyname,
  linkname,
  varfname,
  offset,
  weights,
  penalty,
  nsteps = 100L,
  stepsize = 0.1,
  print = FALSE
)
}
\arguments{
\item{beta}{initial value of the regression coefficients to be estimated}

\item{y}{response vector}

\item{X}{design matrix}

\item{familyname}{model family name}

\item{linkname}{link function name}

\item{varfname}{variance function name}

\item{offset}{vector of constants to be added to the linear predictor}

\item{weights}{vector of constants non-negative weights}

\item{penalty}{penalty parameter of a ridge-type penalty}

\item{nsteps}{number of iterations}

\item{stepsize}{stepsize parameter of the Fisher scoring algorithm}

\item{print}{if \code{TRUE}, print the algorithm history}
}
\description{
Internal function implementing the Fisher scoring algorithms for the
estimation of GLMs. It is used in the AIRWLS algorithm for the 
estimation of GMF models.
}
\keyword{internal}
