% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_to_zero.R
\name{fix_to_zero}
\alias{fix_to_zero}
\title{Fix a Free Parameter To Zero And Fit a Model Again}
\usage{
fix_to_zero(fit, par_id, store_fit = FALSE, se_keep_bootstrap = FALSE)
}
\arguments{
\item{fit}{A \code{lavaan}-class object.}

\item{par_id}{An integer. The row
number of the free parameter in the
parameter table of \code{fit} to be
fixed.}

\item{store_fit}{Logical. If \code{TRUE},
\code{fit} will be stored in the output.
Default is \code{FALSE}.}

\item{se_keep_bootstrap}{Logical.
If \code{TRUE} and \code{fit} used
bootstrapping standard error
(with \code{se = "bootstrap"}), bootstrapping
will also be use in fitting the
restricted model. If \code{FALSE}, the
default, then \code{se} will be set
to \code{"standard"} if it is \code{"bootstrap"}
in \code{fit}, to speed up the computation.}
}
\value{
A \code{fix_to_zero}-class object, which
is a list with these elements:
\itemize{
\item \code{fit0} is the \code{lavaan} output of the
refitted object. \code{NA} if the fit
failed for some reasons. To be
considered an acceptable solution,
the optimization must converge,
the solution passes \code{lavaan}'s
post check,
the variance-covariance matrix of
estimates successfully computed,
and the increase in the model
degree of freedom equal to the
expected change.
\item \code{fit1} is the original \code{lavaan}
output if \code{store_fit} is \code{TRUE}. It
is \code{NULL} if \code{store_fit} is \code{FALSE},
the default.
\item \code{par_id} is the row number of the
designated free parameter in the
parameter table.
\item \code{call} is the original call to this
function.
\item \code{ptable0} is the parameter table
with the designated parameter fixed
to zero. It can be used for diagnostic
purpose if the fit failed.
\item \code{fit0_error} is the error
message in refitting the model
(\code{ptable0}), if
any. If
no error, it is \code{NA}.
\item \code{vcov_ok} is \code{TRUE} if the
variance-covariance matrix of the
estimates
can be computed without error nor
warning. \code{FALSE} otherwise.
\item \code{vcov_msg} is the message generated
when using \code{\link[lavaan:lavInspect]{lavaan::lavInspect()}} to
get the variance-covariance matrix
of the parameter estimates of the
refitted model. If \code{TRUE}, then no
error nor warning. Can be used for
diagnostic purposes.
\item \code{converged}: Whether refitting
the modified model (\code{ptable0})
converged.
\item \code{post_check_passed}: Whether the
solution of the modified model
(\code{ptable0}) passed
\code{lavaan}'s post check.
\item \code{post_check_msg}: If the solution
failed \code{lavaan}'s post check,
it stores the warning message.
If the solution passes the check,
it is \code{NA}.
\item \code{fit_not_ok}: If the fit failed
for some reasons, the fit object,
if available, is stored in this
element rather than in \code{fit0}. such
that the fit object can be retrieved
for diagnostic purposed if necessary.
\item \code{df_diff_one}: Whether the
difference in model degrees of
freedom between the modified model
and the original model is one. If
a variance is fitted to zero, related
covariance(s) is/are also fitted to
zero and so the difference in
model degrees of freedom can be
legitimately greater than one.
\item \code{se_force_standard}: Whether
\code{se} was forced to be \code{"standard"}
even if it is \code{"bootstrap"} in
\code{fit}. If \code{FALSE}, then either
\code{se} is not \code{"bootstrap"} in
\code{fit} or it was not changed in
fitting the restricted model.
}
}
\description{
It fixes a designated free parameter
in a lavaan object to zero and refit the model.
}
\details{
It modifies the parameter
table of a \code{lavaan}-class object and
then fits the model again.

Users should usually call
\code{\link[=lrtp]{lrtp()}} directly instead of calling
this function. It is exported for
developers.
}
\examples{
library(lavaan)
data(data_sem16)
mod <-
"
f1 =~ x1 + x2 + x3
f2 =~ x4 + x5 + x6
"
fit <- sem(mod, data_sem16)
# Fix the factor covariance to zero
out <- fix_to_zero(fit, par_id = 15)
summary(out$fit0)

}
\seealso{
\code{\link[=lrtp]{lrtp()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
