% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denoise.R
\name{correct_counts}
\alias{correct_counts}
\title{Correct data by setting all latent factors to their median values and reversing the regression model}
\usage{
correct_counts(
  x,
  umi,
  cell_attr = x$cell_attr,
  scale_factor = NA,
  verbosity = 2
)
}
\arguments{
\item{x}{A list that provides model parameters and optionally meta data; use output of vst function}

\item{umi}{The count matrix}

\item{cell_attr}{Provide cell meta data holding latent data info}

\item{scale_factor}{Replace all values of UMI in the regression model by this value. Default is NA
which uses median of total UMI as the latent factor.}

\item{verbosity}{An integer specifying the verbosity level: 0 (silent, no messages), 1 (show messages only), or 2 (show messages and progress bars); default is 2}
}
\value{
Corrected data as UMI counts
}
\description{
This version does not need a matrix of Pearson residuals. It takes the count matrix as input and
calculates the residuals on the fly. The corrected UMI counts will be rounded to the nearest
integer and negative values clipped to 0.
}
\examples{
\donttest{
vst_out <- vst(pbmc, return_cell_attr = TRUE)
umi_corrected <- correct_counts(vst_out, pbmc)
}

}
