% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss4ddp.R
\name{ss4ddp}
\alias{ss4ddp}
\title{The required sample size for estimating a double difference of proportions}
\usage{
ss4ddp(
  N,
  P1,
  P2,
  P3,
  P4,
  DEFF = 1,
  conf = 0.95,
  cve = 0.05,
  me = 0.03,
  T = 0,
  R = 1,
  plot = FALSE
)
}
\arguments{
\item{N}{The population size.}

\item{P1}{The value of the first estimated proportion at first wave.}

\item{P2}{The value of the second estimated proportion at first wave.}

\item{P3}{The value of the first estimated proportion at second wave.}

\item{P4}{The value of the second estimated proportion at second wave.}

\item{DEFF}{The design effect of the sample design. By default \code{DEFF = 1}, which corresponds to a simple random sampling design.}

\item{conf}{The statistical confidence. By default conf = 0.95. By default \code{conf = 0.95}.}

\item{cve}{The maximun coeficient of variation that can be allowed for the estimation.}

\item{me}{The maximun margin of error that can be allowed for the estimation.}

\item{T}{The overlap between waves. By default \code{T = 0}.}

\item{R}{The correlation between waves. By default \code{R = 1}.}

\item{plot}{Optionally plot the errors (cve and margin of error) against the sample size.}
}
\description{
This function returns the minimum sample size required for estimating a double difference of proportion subjecto to predefined errors.
}
\details{
Note that the minimun sample size (for each group at each wave) to achieve a particular margin of error \eqn{\varepsilon} is defined by: 
\deqn{n = \frac{n_0}{1+\frac{n_0}{N}}}
Where \deqn{n_0=\frac{z^2_{1-\frac{\alpha}{2}}S^2}{\varepsilon^2}}
and
\deqn{S^2 = (P1 * Q1 + P2 * Q2 + P3 * Q3 + P4 * Q4) * (1 - (T * R)) * DEFF}
Also note that the minimun sample size to achieve a particular coefficient of variation \eqn{cve} is defined by:
\deqn{n = \frac{S^2}{(ddp)^2cve^2+\frac{S^2}{N}}} 
And \eqn{ddp} is the expected estimate of the double difference of proportions.
}
\examples{
ss4ddp(N=100000, P1=0.05, P2=0.55, P3= 0.5, P4= 0.6, cve=0.05, me=0.03)
ss4ddp(N=100000, P1=0.05, P2=0.55, P3= 0.5, P4= 0.6, cve=0.05, me=0.03, plot=TRUE)
ss4ddp(N=100000, P1=0.05, P2=0.55, P3= 0.5, P4= 0.6, DEFF=3.45, conf=0.99, 
cve=0.03, me=0.03, plot=TRUE)
ss4ddp(N=100000, P1=0.05, P2=0.55, P3= 0.5, P4= 0.6, DEFF=3.45, conf=0.99,
 cve=0.03, me=0.03, T = 0.5, R = 0.9, plot=TRUE)

#################################
# Example with BigLucyT0T1 data #
#################################
data(BigLucyT0T1)
attach(BigLucyT0T1)

BigLucyT0 <- BigLucyT0T1[Time == 0,]
BigLucyT1 <- BigLucyT0T1[Time == 1,]
N1 <- table(BigLucyT0$SPAM)[1]
N2 <- table(BigLucyT1$SPAM)[1]
N <- max(N1,N2)
P1 <- prop.table(table(BigLucyT0$ISO))[1]
P2 <- prop.table(table(BigLucyT1$ISO))[1]
P3 <- prop.table(table(BigLucyT0$ISO))[2]
P4 <- prop.table(table(BigLucyT1$ISO))[2]
# The minimum sample size for simple random sampling
ss4ddp(N, P1, P2, P3, P4, conf=0.95, cve=0.05, me=0.03, plot=TRUE)
# The minimum sample size for a complex sampling design
ss4ddp(N, P1, P2, P3, P4, T = 0.5, R = 0.5, conf=0.95, cve=0.05, me=0.03, plot=TRUE)
}
\references{
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{ss4dp}}
}
\author{
Hugo Andres Gutierrez Rojas <hagutierrezro at gmail.com>
}
