% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_ccd.R
\name{design_ccd}
\alias{design_ccd}
\title{Defines a CCD for k quantitative factors}
\usage{
design_ccd(j, k)
}
\arguments{
\item{j}{the number of replicates of the central point}

\item{k}{the number of quantitative factors used or studied in the experimentation.}
}
\value{
Three output tables containing the level of replication (number of replicates) and the experimental uncoded
   values of the quantitative factors to be used for experimentation and one plot showing
   the corresponding variance of the predicted response.

\dQuote{Factorial.Points}, the first table which contains the treatment combinations for a 2^\emph{k} factorial design
   (which, in coded form, corresponds to the vertices of a square, a cube, or a hyper-cube when \emph{k} = 2, 3 and
   more).

\dQuote{Axial.Points}, the second table which contains 2k axial or \dQuote{star} points.

\dQuote{Central.Point}, the third table which contains the number of replicates for the central point, coded (0, 0, 0).
}
\description{
Defines a rotatable central composite design (CCD) for experimentation with
   k quantitative factors and j replicates of the central point
   (which corresponds to the \sQuote{average treatment combination}).
}
\examples{
#Enter the function as shown below. The user will be prompted to input smallest
#and greatest values for each factor that will be used for experimentation.

if(interactive()){
 design_ccd(5, 3)
 }

}
\references{
Mead, R., Gilmour, S. G., and Mead, A. 2012. Statistical Principles for the Design of Experiments:
   Applications to Real Experiments. Cambridge University Press, Cambridge.

Panneton, B., Philion, H., Dutilleul, P., Theriault, R., and Khelifi, M. 1999. Full factorial design
   versus central composite design: Statistical comparison and experimental implications for spray
   droplet deposition. Transactions of the American Society of Agricultural Engineers 42:877-883.
}
