% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{Maxwell}
\alias{Maxwell}
\alias{rmaxwell}
\alias{dmaxwell}
\alias{pmaxwell}
\title{The modified Maxwell-Boltzmann distribution}
\usage{
dmaxwell(r, kappa = 1, nu = NULL, Haar = TRUE)

pmaxwell(q, kappa = 1, nu = NULL, lower.tail = TRUE)

rmaxwell(n, kappa = 1, nu = NULL)
}
\arguments{
\item{r, q}{vector of quantiles.}

\item{kappa}{concentration parameter.}

\item{nu}{circular variance, can be used in place of \code{kappa}.}

\item{Haar}{logical; if TRUE density is evaluated with respect to the Haar measure.}

\item{lower.tail}{logical; if TRUE (default) probabilities are \eqn{P(X\leq x)}{P(X\le x)} otherwise, \eqn{P(X>x)}.}

\item{n}{number of observations.  If \code{length(n)>1}, the length is taken to be the number required.}
}
\value{
\item{dmaxwell}{gives the density}
         \item{pmaxwell}{gives the distribution function}
         \item{rmaxwell}{generates a vector of random deviates}
}
\description{
Density, distribution function and random generation for the Maxwell-Boltzmann distribution with
concentration \code{kappa} \eqn{\kappa} restricted to the range \eqn{[-\pi,\pi)}.
}
\details{
The Maxwell-Boltzmann distribution with concentration \eqn{\kappa} has density
\deqn{C_\mathrm{{M}}(r|\kappa)=2\kappa\sqrt{\frac{\kappa}{\pi}}r^2e^{-\kappa r^2}}{C(r|\kappa)=2\kappa(\kappa/\pi)^(1/2)r^2exp(-\kappa r^2)}
with respect to Lebesgue measure.  The usual expression for the Maxwell-Boltzmann distribution can be recovered by
setting \eqn{a=(2\kappa)^0.5}.

bingham2010
}
\examples{
r <- seq(-pi, pi, length = 500)

#Visualize the Maxwell-Boltzmann density fucntion with respect to the Haar measure
plot(r, dmaxwell(r, kappa = 10), type = "l", ylab = "f(r)")

#Visualize the Maxwell-Boltzmann density fucntion with respect to the Lebesgue measure
plot(r, dmaxwell(r, kappa = 10, Haar = FALSE), type = "l", ylab = "f(r)")

#Plot the Maxwell-Boltzmann CDF
plot(r,pmaxwell(r,kappa = 10), type = "l", ylab = "F(r)")

#Generate random observations from Maxwell-Boltzmann distribution
rs <- rmaxwell(20, kappa = 1)
hist(rs, breaks = 10)
}
\seealso{
\link{Angular-distributions} for other distributions in the rotations package.
}
