% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oadoi_fetch.r
\name{oadoi_fetch}
\alias{oadoi_fetch}
\title{Fetch open access status information and full-text links using Unpaywall}
\usage{
oadoi_fetch(
  dois = NULL,
  email = Sys.getenv("roadoi_email"),
  .progress = "none",
  .flatten = FALSE
)
}
\arguments{
\item{dois}{character vector, search by a single DOI or many DOIs.
A rate limit of 100k requests per day is suggested. If you need to access
more data, request the data dump
\url{https://unpaywall.org/dataset} instead.}

\item{email}{character vector, mandatory!
Unpaywall requires your email address,
so that they can track usage and notify you when something breaks.
Set email address in your `.Renviron` file with
the option
`roadoi_email` \code{options(roadoi_email = "najko.jahn@gmail.com")}.
You can open your `.Renviron` file calling `file.edit("~/.Renviron")`.
Save the file and restart your R session. To stop sharing your email
when using rcrossref, delete it from your `.Renviron` file.}

\item{.progress}{Shows the \code{plyr}-style progress bar.
Options are "none", "text", "tk", "win", and "time".
See \code{\link[plyr]{create_progress_bar}} for details
of each. By default, no progress bar is displayed.}

\item{.flatten}{Simplify open access evidence output. If `TRUE` it
transforms the nested column oa_locations so that each open access
evidence variable has its own column and each row represents a
single full-text.
Following these basic principles of "Tidy Data" makes data analysis
and export as a spreadsheet more straightforward.}
}
\value{
The result is a tibble with each row representing a publication.
  Here are the returned columns and descriptions according to the API docu:


\tabular{ll}{
 \code{doi}              \tab DOI (always in lowercase). \cr
 \code{best_oa_location} \tab list-column describing the best OA location.
 Algorithm prioritizes publisher hosted content (eg Hybrid or Gold),
 then prioritizes versions closer to the  version of record (PublishedVersion
 over AcceptedVersion), then more authoritative  repositories (PubMed Central
 over CiteSeerX). \cr
 \code{oa_locations}     \tab list-column of all the OA locations. \cr
 \code{oa_locations_embargoed}  \tab list-column of
 locations expected to be available in the future based on
  information like license metadata and journals'
  delayed OA policies \cr
 \code{data_standard}    \tab Indicates the data collection approaches used
 for this resource. \code{1} mostly uses Crossref for hybrid detection.
 \code{2} uses a more comprehensive hybrid detection methods. \cr
 \code{is_oa}            \tab Is there an OA copy (logical)? \cr
 \code{is_paratext}      \tab Is the item an ancillary part of a journal,
 like a table of contents? See here for more information
 \url{https://support.unpaywall.org/support/solutions/articles/44001894783}. \cr
 \code{genre}            \tab Publication type \cr
 \code{oa_status}        \tab Classifies OA resources by location
 and license terms as one of: gold, hybrid, bronze, green or closed.
 See here for more information
 \url{https://support.unpaywall.org/support/solutions/articles/44001777288-what-do-the-types-of-oa-status-green-gold-hybrid-and-bronze-mean-}. \cr
 \code{has_repository_copy} \tab Is a full-text
 available in a repository? \cr
 \code{journal_is_oa}    \tab Is the article published in a fully
 OA journal? \cr
 \code{journal_is_in_doaj} \tab Is the journal listed in
  the Directory of Open Access Journals (DOAJ). \cr
 \code{journal_issns}    \tab ISSNs, i.e. unique numbers to identify
 journals. \cr
 \code{journal_issn_l}    \tab Linking ISSN. \cr
 \code{journal_name}     \tab Journal title, not normalized. \cr
 \code{publisher}        \tab Publisher, not normalized. \cr
 \code{published_date}   \tab Date published \cr
 \code{year}             \tab Year published. \cr
 \code{title}            \tab Publication title. \cr
 \code{updated_resource} \tab Time when the data for this resource was last updated. \cr
 \code{authors}          \tab Lists author information (\code{family} name, \code{given}
 name and author role \code{sequence}), if available. \cr
}

The columns  \code{best_oa_location}. \code{oa_locations} and
\code{oa_locations_embargoed} are list-columns that contain
useful metadata about the OA sources found by Unpaywall.

If \code{.flatten = TRUE} the list-column \code{oa_locations} will be
restructured in a long format where each OA fulltext is represented by
one row.

These are:

\tabular{ll}{
 \code{endpoint_id}     \tab Unique repository identifier. \cr
 \code{evidence}        \tab How the OA location was found and is characterized
  by Unpaywall? \cr
 \code{host_type}       \tab OA full-text provided by \code{publisher} or
  \code{repository}. \cr
 \code{is_best}         \tab Is this location the \code{best_oa_location} for its resource? \cr
 \code{license}         \tab The license under which this copy is published,
  e.g. Creative Commons license. \cr
 \code{pmh_id}          \tab OAI-PMH endpoint where we found this location. \cr
 \code{repository institution} \tab Hosting institution of the repository. \cr
 \code{updated}         \tab Time when the data for this location was last updated. \cr
 \code{url}             \tab The \code{url_for_pdf} if there is one; otherwise landing page URL. \cr
 \code{url_for_landing_page} \tab The URL for a landing page describing this OA copy. \cr
 \code{url_for_pdf}     \tab The URL with a PDF version of this OA copy. \cr
 \code{version}        \tab The content version accessible at this location
  following the DRIVER 2.0 Guidelines
 (\url{https://wiki.surfnet.nl/display/DRIVERguidelines/DRIVER-VERSION+Mappings}
 \cr
}

Note that Unpaywall schema is only informally described.
Check also \url{https://unpaywall.org/data-format}.
}
\description{
This is the main function to retrieve comprehensive open access status
information from Unpaywall data service. Please play nice with the API.
For each user, 100k calls per day are suggested. If you need to access
more data, there is also a data dump available.
For more info see \url{https://unpaywall.org/products/snapshot}.
}
\examples{
\dontrun{
oadoi_fetch("10.1038/nature12373", email = "name@example.com")
oadoi_fetch(dois = c("10.1016/j.jbiotec.2010.07.030",
"10.1186/1471-2164-11-245"), email = "name@example.com")
# flatten OA evidence
roadoi::oadoi_fetch(dois = c("10.1186/s12864-016-2566-9",
                            "10.1103/physreve.88.012814",
                            "10.1093/reseval/rvaa038"),
                   email = "najko.jahn@gmail.com", .flatten = TRUE)

}

}
