% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\title{Get data from within the package}
\usage{
get_data(
  scale = 110L,
  type = c("countries", "map_units", "sovereignty", "tiny_countries")
)
}
\arguments{
\item{scale}{The scale of map to return, one of `110`, `50`, `10` or `small`,
`medium`, `large`.}

\item{type}{country type, one of 'countries', 'map_units', 'sovereignty',
'tiny_countries'}
}
\value{
A \code{sf} object.
}
\description{
returns world country polygons at a specified scale, used by ne_countries()
}
\details{
Note that the filename of the requested object will be returned if
`load = FALSE`.

If the data is to be loaded into memory (`load = TRUE`), the download will
be handled using the GDAL virtual file system, allowing direct access to the
data without writing it to disk.
}
\examples{
\dontrun{
spdf_world <- ne_download(scale = 110, type = "countries")

plot(spdf_world)
plot(ne_download(type = "populated_places"))

# reloading from the saved file in the same session with same arguments

spdf_world2 <- ne_load(scale = 110, type = "countries")

# download followed by load from specified directory will work across sessions
spdf_world <- ne_download(scale = 110, type = "countries", destdir = getwd())
spdf_world2 <- ne_load(scale = 110, type = "countries", destdir = getwd())

# for raster, here an example with Manual Shaded Relief (MSR) download & load

rst <- ne_download(scale = 50, type = "MSR_50M", category = "raster", destdir = getwd())

# load after having downloaded
rst <- ne_load(
  scale = 50, type = "MSR_50M", category = "raster", destdir = getwd()
)

# plot
library(terra)
terra::plot(rst)
# end dontrun
}

}
\seealso{
\code{\link{ne_load}}, pre-downloaded data are available using
  \code{\link{ne_countries}}, \code{\link{ne_states}}. Other geographic data
  are available in the raster package : \code{\link[raster]{getData}}.
}
