% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorMarker.R
\name{calcDatasetSpecificity}
\alias{calcDatasetSpecificity}
\title{Calculate a dataset-specificity score for each factor}
\usage{
calcDatasetSpecificity(
  object,
  dataset1,
  dataset2,
  doPlot = FALSE,
  do.plot = doPlot
)
}
\arguments{
\item{object}{\linkS4class{liger} object with factorization results.}

\item{dataset1}{Name of first dataset. Required.}

\item{dataset2}{Name of second dataset. Required.}

\item{doPlot}{Logical. Whether to display a barplot of dataset specificity
scores (by factor). Default \code{FALSE}.}

\item{do.plot}{\bold{Deprecated}. Use \code{doPlot} instead.}
}
\value{
List containing three elements.
\item{pct1}{Vector of the norm of each metagene factor for dataset1.}
\item{pct2}{Vector of the norm of each metagene factor for dataset2.}
\item{pctSpec}{Vector of dataset specificity scores.}
}
\description{
This score represents the relative magnitude of the
dataset-specific components of each factor's gene loadings compared to the
shared components for two datasets. First, for each dataset we calculate the
norm of the sum of each factor's shared loadings (\eqn{W}) and
dataset-specific loadings (\eqn{V}). We then determine the ratio of these two
values and subtract from 1... TODO: finish description.
}
