% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rif.R
\name{compute_gini}
\alias{compute_gini}
\title{Compute Gini coefficient}
\usage{
compute_gini(dep_var, weights)
}
\arguments{
\item{dep_var}{values of a non-negative continuous variable}

\item{weights}{numeric vector of non-negative observation weights, hence of same length as \code{dep_var}.}
}
\value{
The numeric value indicating the weighted Gini coefficient of the the dependent variable.
}
\description{
Compute a weighted Gini coefficient by integrating the
generalized Lorenz curve.
}
\examples{

set.seed(123)
dep_var <- rlnorm(100)
weights <- rep(1, 100)
compute_gini(dep_var, weights)

}
\references{
Firpo, Sergio P., Nicole M. Fortin, and Thomas Lemieux. 2018. “Decomposing Wage Distributions Using Recentered
Influence Function Regressions.” \emph{Econometrics} 6(2), 28.
}
