% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refitME_package.r
\docType{data}
\name{Milanmortdata}
\alias{Milanmortdata}
\title{The Milan mortality data set}
\format{
This data frame contains the following columns:
\describe{
\item{day.num}{number of days since 31st December, 1979.}
\item{day.of.week}{1 = Monday, 2 = Tuesday, 3 = Wednesday, 4 = Thursday, 5 = Friday, 6 = Saturday, 7 = Sunday.}
\item{holiday}{indicator of public holiday: 1 = public holiday, 0 = otherwise.}
\item{mean.temp}{mean daily temperature in degrees Celcius.}
\item{rel.humid}{relative humidity.}
\item{tot.mort}{total number of deaths.}
\item{resp.mort}{total number of respiratory deaths.}
\item{SO2}{measure of sulphur dioxide level in ambient air.}
\item{TSP}{total suspended particles in ambient air.}
}
}
\source{
Vigotti, M.A., Rossi, G., Bisanti, L., Zanobetti, A. and Schwartz, J. (1996). Short term effect of urban air pollution on respiratory health in Milan, Italy, 1980-1989. \emph{Journal of Epidemiology and Community Health}, \strong{50}, S71-S75.
}
\usage{
Milanmortdata
}
\description{
The \code{Milanmortdata} data frame has data on 3652 consecutive days (10 consecutive years: 1st January, 1980 to 30th December, 1989) for the city of Milan, Italy. Note that this data set was originally contained and available from the now discontinued SemiPar R-package. With the permission of Matt Wand we have made these data (now called Milanmortdata) available in the refitME R-package.
}
\examples{
# Load the data.

data(Milanmortdata)
pairs(Milanmortdata, pch = ".")
}
\references{
Ruppert, D., Wand, M.P. and Carroll, R.J. (2003). \emph{Semiparametric Regression} Cambridge University Press.
}
\keyword{datasets}
