% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recoding.R
\name{assign_coding}
\alias{assign_coding}
\title{Adds a coding as an attribute to a vector}
\usage{
assign_coding(vec, .coding, .bpr = TRUE)
}
\arguments{
\item{vec}{A vector}

\item{.coding}{A `coding` object}

\item{.bpr}{Also overwrite the "bpr.coding" attribute with the character
representation of `.coding`. Used for interop with blueprintr
variable decorations.}
}
\value{
The vector with its "rcoder.coding" attribute set to `.coding`
}
\description{
Stores a coding at the "rcoder.coding" attribute of a vector
}
\examples{
cdng <- coding(code("Yes", 3), code("Maybe", 2), code("No", 1))
vec <- sample(1:3, 50, replace = TRUE)
assign_coding(vec, cdng)
}
\seealso{
[recode_vec()]
}
