% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nullify.R
\name{nullify}
\alias{nullify}
\title{Converts all values specified in the CLDF metadata as \code{null} to R's \code{NA}.}
\usage{
nullify(cldfobj, nulls = NULL)
}
\arguments{
\item{cldfobj}{a CLDF Object}

\item{nulls}{a dataframe of null values to replace (default=NULL).}
}
\value{
A \code{cldf} object
}
\description{
Note that this is run by default on loading a dataset with cldf()
}
\examples{
cldfobj <- cldf(system.file("extdata/huon", "cldf-metadata.json", package = "rcldf"))
cldfobj <- nullify(cldfobj)
}
