% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosscalibrate_lens.R
\name{crosscalibrate_lens}
\alias{crosscalibrate_lens}
\title{Cross-calibrate lens}
\usage{
crosscalibrate_lens(
  path_to_csv_uncal,
  path_to_csv_cal,
  zenith_colrow_uncal,
  zenith_colrow_cal,
  diameter_cal,
  lens_coef,
  degree = 3
)
}
\arguments{
\item{path_to_csv_uncal, path_to_csv_cal}{character vectors of length one.
Paths to CSV files created with ImageJ’s point selection tool (uncalibrated
and calibrated images, respectively).}

\item{zenith_colrow_uncal, zenith_colrow_cal}{numeric vectors of length two.
Raster coordinates of the zenith for the uncalibrated and calibrated
images; see \code{\link[=calc_zenith_colrow]{calc_zenith_colrow()}}.}

\item{diameter_cal}{numeric vector of length one. Image diameter (pixels) of
the calibrated camera.}

\item{lens_coef}{numeric vector. Lens projection coefficients of the
calibrated camera.}

\item{degree}{numeric vector of length one. Polynomial degree for the
uncalibrated model fit (default 3).}
}
\value{
List with components:
\describe{
\item{\code{ds}}{\code{data.frame} with zenith angle (\code{theta}, radians) and pixel radius
(\code{px}) from the uncalibrated camera.}
\item{\code{model}}{\code{lm} object: polynomial fit of \code{px} ~ \code{theta}.}
\item{\code{horizon_radius}}{numeric vector of length one. Pixel radius at 90 deg.}
\item{\code{lens_coef}}{numeric vector. Distortion coefficients normalized by
\code{horizon_radius}.}
}
}
\description{
Given two photographs taken from the same point (matching entrance pupils and
aligned optical axes), with calibrated and uncalibrated cameras, derives a
polynomial projection for the uncalibrated device. Intended for cases where a
camera calibrated with a method of higher accuracy than \code{\link[=calibrate_lens]{calibrate_lens()}} is
available, or when there is a main camera to which all other devices should
be adjusted.

Points must be digitized in tandem with ImageJ and saved as CSV files.
See \code{\link[=calibrate_lens]{calibrate_lens()}} for background and general concepts.
}
\details{
Estimate a lens projection for an uncalibrated camera by referencing a
calibrated camera photographed from the exact same location.
}
\seealso{
\code{\link[=calibrate_lens]{calibrate_lens()}}, \code{\link[=calc_zenith_colrow]{calc_zenith_colrow()}}
}
