% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-girsanov.R
\name{fitflow_girsanov}
\alias{fitflow_girsanov}
\title{Fit Flow with Girsanov-Tilted Likelihood}
\usage{
fitflow_girsanov(
  observed,
  states = NULL,
  flowtype = "maf",
  flowspec = list(),
  inittheta = NULL,
  base_pxgivenz,
  theta_path,
  Winc,
  dt,
  nmc = 256,
  control = list()
)
}
\arguments{
\item{observed}{Empirical distribution Q (probability vector).}

\item{states}{Optional category names.}

\item{flowtype}{Flow type ("maf", "splinepwlin", "planar", "radial").}

\item{flowspec}{Structural parameters for the flow.}

\item{inittheta}{Optional initial theta for trainable flows.}

\item{base_pxgivenz}{Likelihood \eqn{p(x \mid z)} before tilting.}

\item{theta_path}{Drift-tilting function or vector for Girsanov.}

\item{Winc}{Brownian increments.}

\item{dt}{Time step.}

\item{nmc}{Monte Carlo samples.}

\item{control}{Control list for \code{optim()}.}
}
\value{
Output of \code{fitflowvariational()}.
}
\description{
Applies a Girsanov change of measure to tilt the likelihood and then
fits a flow-based variational posterior using \code{fitflowvariational()}.
}
\details{
This is useful when the target distribution arises from a drift-tilted
diffusion process, where the Radon-Nikodym derivative is given by the
Girsanov theorem.
}
