% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_methods.R
\name{make_methods}
\alias{make_methods}
\title{Make methods}
\usage{
make_methods(
  r6,
  field = c("all", "public", "private", names(r6$public_fields),
    names(r6$private_fields)),
  method = c("both", "get", "set"),
  add_roxygen = TRUE
)
}
\arguments{
\item{r6}{R6 class for which to create methods}

\item{field}{Character, fields for which to create method. May be "all",
"public", "private" or name of class field. Multiple values allowed.}

\item{method}{Character, methods to create. One of "both", "get", "set"}

\item{add_roxygen}{Logical, whether to add roxygen description of method}
}
\value{
Character containing generated methods to put into class definition
}
\description{
Make methods
}
\examples{
Example <- R6::R6Class("Example", list(public_field = NULL), list(private_field = NULL))
make_methods(Example)
make_methods(Example, "private", "get")
make_methods(Example, "private_field", c("get", "set"))
make_methods(Example, "public_field", c("both"))
}
