% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-colours.R
\name{getColors}
\alias{getColors}
\alias{getColours}
\alias{setColors<-}
\alias{setColours}
\alias{setColors}
\title{Get and set colours for plotting \verb{Raster*} objects}
\usage{
getColors(object)

setColors(object, ..., n, verbose = getOption("quickPlot.verbose")) <- value

setColors(object, value, n, verbose = getOption("quickPlot.verbose"))
}
\arguments{
\item{object}{A \verb{Raster*} object.}

\item{...}{Additional arguments to \code{colorRampPalette}.}

\item{n}{An optional vector of values specifying the number
of levels from which to interpolate the colour palette.}

\item{verbose}{Numeric or logical. If \code{TRUE} or \verb{>0}, then messages will be
shown. If \code{FALSE} or \code{0}, most messages will be suppressed.}

\item{value}{Named list of hex colour codes (e.g., from
\code{RColorBrewer::brewer.pal}), corresponding to the names
of \code{RasterLayer}s in \code{x}.}
}
\value{
Returns a named list of colours.

Returns a Raster with the \code{colortable} slot set to \code{values}.
}
\description{
Get and set colours for plotting \verb{Raster*} objects

\code{setColors} works as a replacement method or a normal function call.
This function can accept \code{RColorBrewer} colours by name. See examples.
}
\examples{
library(terra)

ras <- rast(matrix(c(0, 0, 1, 2), ncol = 2, nrow = 2))

getColors(ras) ## none

# Use replacement method
setColors(ras, n = 3) <- c("red", "blue", "green")
getColors(ras)

clearPlot()
Plot(ras)

# Use function method
ras <- setColors(ras, n = 3, c("red", "blue", "yellow"))
getColors(ras)

clearPlot()
Plot(ras)

# Using the wrong number of colors, e.g., here 2 provided,
# for a raster with 3 values... causes interpolation, which may be surprising
ras <- setColors(ras, c("red", "blue"))
clearPlot()
Plot(ras)

# Real number rasters - interpolation is used
ras <- rast(matrix(runif(9), ncol = 3, nrow = 3)) |>
  setColors(c("red", "yellow")) # interpolates when real numbers, gives warning

clearPlot()
Plot(ras)

# Factor rasters, can be contiguous (numerically) or not, in this case not:
ras <- rast(matrix(sample(c(1, 3, 6), size = 9, replace = TRUE), ncol = 3, nrow = 3))
levels(ras) <- data.frame(ID = c(1, 3, 6), Names = c("red", "purple", "yellow"))
ras <- setColors(ras, n = 3, c("red", "purple", "yellow"))
getColors(ras)

clearPlot()
Plot(ras)

# if a factor raster, and not enough labels are provided, then a warning
#   will be given, and colors will be interpolated
#   The level called purple is not purple, but interpolated betwen red and yellow
suppressWarnings({
  ras <- setColors(ras, c("red", "yellow"))
  clearPlot()
  Plot(ras)
})

# use RColorBrewer colors
setColors(ras) <- "Reds"
clearPlot()
Plot(ras)
}
\seealso{
\code{\link[=setColors<-]{setColors<-()}}, \code{brewer.pal()}, RColorBrewer::ColorBrewer

\code{brewer.pal()}, \code{RColorBrewer::ColorBrewer},
\code{\link[grDevices:colorRamp]{colorRampPalette()}}.
}
\author{
Alex Chubaty
}
