% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossq.plot.R
\name{crossq.plot}
\alias{crossq.plot}
\title{Plot of Cross-Quantilogram}
\usage{
crossq.plot(
  DATA,
  vecA,
  Kmax,
  Bsize,
  sigLev = 0.05,
  vec.lag,
  vec.CQ,
  mat.CI,
  y.min = -1,
  y.max = 1,
  ribbon_color = "gray",
  ribbon_alpha = 0.8,
  bar_color = "black",
  bar_width = 0.2,
  title = "",
  subtitle = NULL
)
}
\arguments{
\item{DATA}{A matrix of dimensions T x 2, where T is the number of observations.
Column 1 contains the first variable and Column 2 contains the second variable.}

\item{vecA}{A numeric vector of quantiles for the first variable.}

\item{Kmax}{An integer representing the maximum lag to compute.}

\item{Bsize}{Bootstrap sample size for stationary bootstrap.}

\item{sigLev}{Significance level for confidence intervals. Default is 0.05 (95\% confidence level).}

\item{vec.lag}{A vector of lag values (integer values). Not used in computation, only for plotting.}

\item{vec.CQ}{A numeric vector of cross-quantilogram values. Not used in computation, only for plotting.}

\item{mat.CI}{A matrix with two columns representing the lower and upper bounds of the confidence interval. Not used in computation, only for plotting.}

\item{y.min}{The minimum y-axis value. Default is -1.}

\item{y.max}{The maximum y-axis value. Default is 1.}

\item{ribbon_color}{Color for the confidence interval ribbon. Default is "gray".}

\item{ribbon_alpha}{Alpha (transparency) for the confidence interval ribbon. Default is 0.8.}

\item{bar_color}{Color for the quantilogram bars. Default is "black".}

\item{bar_width}{Width of the quantilogram bars. Default is 0.2.}

\item{title}{Plot title. Default is an empty string.}

\item{subtitle}{Plot subtitle. Default is NULL (no subtitle).}
}
\value{
A list containing two elements:
\item{plot}{A ggplot object representing the cross-quantilogram plot over lags.}
\item{df.res}{A data frame containing cross-quantilogram values and critical values. It includes the following columns:
\itemize{
\item lag: lag orders.
\item crossQ: The cross-quantilogram values.
\item CI_lower: The lower critical values for the confidence interval.
\item CI_upper: The upper critical values for the confidence interval.
}
}

A list containing two elements:
\item{plot}{A ggplot object representing the cross-quantilogram plot.}
\item{df.res}{A data frame containing lag values, cross-quantilogram values, and confidence intervals.}
}
\description{
This function creates a plot of the cross-quantilogram with confidence intervals.
It computes the cross-quantilogram and its confidence intervals using stationary bootstrap,
then creates a ggplot visualization of the results.
}
\examples{
\dontrun{
data("sys.risk")
DATA = sys.risk[,c("JPM", "Market")]
vecA = 0.05
Kmax = 20
Bsize = 200
result = crossq.plot(DATA, vecA, Kmax, Bsize)
print(result$plot)
}

}
\references{
Han, H., Linton, O., Oka, T., and Whang, Y. J. (2016).
"The cross-quantilogram: Measuring quantile dependence and testing directional predictability between time series." \emph{Journal of Econometrics}, 193(1), 251-270.
}
\author{
Heejoon Han, Oliver Linton, Tatsushi Oka and Yoon-Jae Whang
}
