% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice_samplers_univariate.R
\name{slice_latent}
\alias{slice_latent}
\title{Latent Slice Sampler}
\usage{
slice_latent(x, s, log_target, rate)
}
\arguments{
\item{x}{The current state (as a numeric scalar).}

\item{s}{A random variable that determines the length of the initial shrinking interval.}

\item{log_target}{A function taking numeric scalar that evaluates the
(potentially unnormalized) log-target density, returning a numeric scalar.}

\item{rate}{The rate parameter for the distribution of \code{s}.}
}
\value{
A list containing three elements:

\code{x} is the new state of the target variable.

\code{s} is the new state of the latent scale variable.

\code{nEvaluations} is the number of evaluations of the
target function used to obtain the new state.
}
\description{
Single update using the latent slice sampler of Li and Walker (2023).
}
\examples{
lf <- function(x) dbeta(x, 3, 4, log = TRUE)
draws <- numeric(10) # set to numeric(1e3) for more complete illustration
nEvaluations <- 0L
s <- 0.5
for (i in seq.int(2, length(draws))) {
  out <- slice_latent(draws[i - 1], s, log_target = lf, rate = 0.3)
  draws[i] <- out$x
  s <- out$s
  nEvaluations <- nEvaluations + out$nEvaluations
}
nEvaluations / (length(draws) - 1)
plot(density(draws), xlim = c(0, 1))
curve(exp(lf(x)), 0, 1, col = "blue", add = TRUE)

}
\references{
Li, Y. and Walker, S. G. (2023), "A latent slice sampling algorithm," \emph{Computational Statistics and Data Analysis}, 179, 107652. \doi{https://doi.org/10.1016/j.csda.2022.107652}
}
