% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModElasticity.R
\name{ModElasticity}
\alias{ModElasticity}
\title{Modulus of elasticity}
\usage{
ModElasticity(data, sample = "sample",
  water.potential = "water.potential", RWD = "RWD", graph = TRUE,
  show.legend = TRUE)
}
\arguments{
\item{data}{data frame containing columns of equal lengths giving the numerical
coordinates of the curve: water potential (bar) and RWD (\%), ordered by sample by descending water potential. A
column containing the sample IDs is optionally required if several samples were measured}

\item{sample}{optional column name in data containing the sample ID, default: "sample"}

\item{water.potential}{optional column name in data containing the water potential values of the leaf
(bar), default: "water.potential"}

\item{RWD}{optional column name in data containing the relative water deficit values (\%), default: "RWD"}

\item{graph}{set FALSE if no plots are to be returned}

\item{show.legend}{set FALSE if no legend is to be shown in the plots}
}
\value{
List splitted by sample consisting of
\item{modulus.elasticity}{modulus of elasticity (bar)}
\item{formula}{formula of the transformed linear osmotic potential fit (1/-bar) and the pressure potential (bar) fit}
\item{coef}{coefficients of the osmotic (1/-bar) and pressure potential (bar) fit}
\item{conf_int}{upper (97.5 \%) and lower (2.5 \%) border of 95 \% confidence interval of model parameters}
If graph = TRUE, the original data is displayed with the x- and y-axis intercepts of the turgor loss
point, the osmotic potential fit and
the linear regression line of the pressure potential.
}
\description{
Determines pressure potential and the modulus of elasticity
}
\details{
Relative water deficit at turgor loss point is determined via the function TurgorLossPoint() and
osmotic potential is calculated via the function OsmoticPot(). \cr \cr Pressure potential is derived by
subtracting osmotic potential from water potential. The part of the pressure potential prior the turgor loss
point is then fitted linearly and the modulus of elasticity (M.Elasticity) equals the slope of the fitted line. \cr \cr
Before using this function, check the raw data for an initial plateau. If the exponential decline does not onset directly,
fitting might not succeed.
}
\examples{
#get example data, calculate Relative Water Deficit
data <- RelativeWaterDeficit(pressure_volume_data)[pressure_volume_data$sample == 1, ]

# determine modulus of elasticity and the fitting parameters. Do not plot results.
m_elasticity <- ModElasticity(data, graph = FALSE)

}
