% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tlfb.R
\docType{data}
\name{tlfb}
\alias{tlfb}
\title{Timeline Followback (TLFB) Drug Use Information}
\format{
A tibble with 237,778 rows and
3 variables:

\describe{
\item{\strong{who}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Patient ID \cr
}


}
\item{\strong{what}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Alcohol) \cr
    \tab  \cr
   \emph{Description:} \tab Text description of drugs; for more information, see \href{../doc/harmonization.html#tlfb}{Harmonization Information} \cr
    \tab  \cr
   \emph{Levels:} \tab Alcohol, Amphetamine, Analgesic, Antibiotic, Antidepressant, Antiemetic, Antihistamine, Antipsychotic, Benadryl, Benzodiazepine, Buprenorphine, Caffeine, Cathinones, Clonidine, Cocaine, Dextromethorphan, Ghb, Hallucinogen, Heroin, Inhalant, K2, Kratom, Mdma/Hallucinogen, Methadone, Methylphenidate, Muscle Relaxant, Opioid, Pcp, Pseudoephedrine, Sedatives, THC, Unknown \cr
}


}
\item{\strong{when}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Study Day \cr
}


}
}
}
\usage{
data(tlfb)
}
\description{
This is self-reported drug use. The values are the result of
extensive processing of free text as well as structured values. These
substances are group grouped as opioids: Codeine, Fentanyl, Hydrocodone,
Merperidine, Oxycodone, Oxymorphone, Propoxyphene. \emph{\strong{NOTE: Records where
people self-reported the study drug after it was prescribed have been
removed from this file.}} The \code{all_drugs} dataset contains these nebulous
records. See the vignette
\href{../doc/harmonization.html#tlfb}{Harmonization Information} for more
information.
}
\keyword{datasets}
