% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disruptions.R
\name{disruptions_at_stop}
\alias{disruptions_at_stop}
\title{Disruptions at a given stop}
\usage{
disruptions_at_stop(
  stop_id,
  disruption_status = NULL,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{stop_id}{Integer stop ID.}

\item{disruption_status}{Character. Can be used to filter to either "current"
or "planned" disruptions. Defaults to NULL, in which case no filter is
applied.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble with the following columns: \itemize{
\item \code{disruption_mode}
\item \code{disruption_mode_description}
\item \code{disruption_id}
\item \code{title}
\item \code{url}
\item \code{description}
\item \code{disruption_status}
\item \code{disruption_type}
\item \code{published_on}
\item \code{last_updated}
\item \code{from_date}
\item \code{to_date}
\item \code{routes}
\item \code{stops}
\item \code{colour}
\item \code{display_on_board}
\item \code{display_status}
}
}
\description{
Disruptions at a given stop
}
\examples{
\dontrun{
disruptions_at_stop(1071)
disruptions_at_stop(1071, disruption_status = "current")
}

}
