% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listwise_deletion.R
\name{listwise_deletion}
\alias{listwise_deletion}
\title{Listwise deletion}
\usage{
listwise_deletion(data, cols = dplyr::everything())
}
\arguments{
\item{data}{A data.frame or a data.frame extension (e.g. a tibble).}

\item{cols}{Columns that need to use listwise deletion. See `dplyr::dplyr_tidy_select` for available options.}
}
\value{
An object of the same type as .data with rows revmoed if the row has one `NA` value
}
\description{
Perform listwise deletion (the entire rows is disregarded if the row has one `NA` value)
}
\examples{
test_df = data.frame(col1 = c(1,2,3),col2 = c(1,NA,3),col3 = c(1,2,NA))
listwise_deletion(test_df,col1:col2) # you can see that the row with NA in col3 is not deleted

}
