% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_prompt.R
\name{format_prompt}
\alias{format_prompt}
\title{Format an LLM prompt}
\usage{
format_prompt(
  text,
  instructions = "",
  examples = data.frame(),
  template = "Text: {text}\\nClassification: {label}",
  prompt_template = "{instructions}{examples}{input}",
  separator = "\\n\\n"
)
}
\arguments{
\item{text}{The text to be classified. Can be a character vector or a single string.}

\item{instructions}{Instructions to be included in the prompt (format them like you would format instructions to a human research assistant).}

\item{examples}{A dataframe of "few-shot" examples. Must include one column called 'text' with the example text(s) and another column called "label" with the correct label(s).}

\item{template}{The template for how examples and completions should be formatted, in \code{glue} syntax. If you are including few-shot examples in the prompt, this must contain the \{text\} and \{label\} placeholders.}

\item{prompt_template}{The template for the entire prompt. Defaults to instructions, followed by few-shot examples, followed by the input to be classified.}

\item{separator}{A character that separates examples. Defaults to two carriage returns.}
}
\value{
Returns a formatted prompt that can be used as input for \code{complete_prompt()} or \code{openai::create_completion()}.
}
\description{
Format a text prompt for a Large Language Model. Particularly useful for few-shot text classification tasks. Note that if you are planning to use one of OpenAI's chat models, like ChatGPT or GPT-4, you will want to use the \code{format_chat()} function instead.
}
\examples{
data(scotus_tweets_examples)

format_prompt(text = "I am disappointed with this ruling.",
              instructions = "Decide if the sentiment of this statement is Positive or Negative.",
              examples = scotus_tweets_examples,
              template = "Statement: {text}\nSentiment: {label}")

format_prompt(text = 'I am sad about the Supreme Court',
              examples = scotus_tweets_examples,
              template = '"{text}" is a {label} statement',
              separator = '\n')
}
