% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listcol.R
\name{listcol_filter}
\alias{listcol_filter}
\title{Filter dataframe by list-column elements}
\usage{
listcol_filter(data, col_name, matches, is_regex = FALSE)
}
\arguments{
\item{data}{Dataframe containing a list column (e.g. an issues dataframe)}

\item{col_name}{Character string containing column name of list column (e.g. \code{labels_name} or \code{assignees_login})}

\item{matches}{A character vector containing a regular expression or one or more exact-match values. An observation will be kept
in the returned data if any of the}

\item{is_regex}{Logical to indicate whether charalcter indicates a regular expression or specific values}
}
\value{
Dataframe containing only rows in which list-column contains element matching provided criteria
}
\description{
Some outputs of the \code{get_} and \code{parse_} functions contain list-columns (e.g. the labels column in the issues dataframe).
This is an efficient way to represent the provided information, but may make certain information seem slightly inaccessible. This
function allows users to filter list columns by the presence of one or more values or a regular expression.
}
\examples{
\dontrun{
issues <- get_issues(repo)
issues_df <- parse_issues(issues)

# keep observation containing a label of either "bug" or "feature"
listcol_filter(issues_df, col_name = "labels_name", matches = c("bug", "feature"))

# keep observation containing a label that starts with "region"
listcol_filter(issues_df, col_name = "labels_name", matches = "^region:", is_regex = TRUE)
}
}
