% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/X2s.R
\name{X2s}
\alias{X2s}
\title{Nonlinear Transformation via B-Splines}
\usage{
X2s(X, Xtest = NULL, deg = 3, nknot = NULL, reduce.knots = FALSE)
}
\arguments{
\item{X}{Numeric matrix or vector of input data.}

\item{Xtest}{Optional numeric matrix or vector of test data. Defaults to \code{X}.}

\item{deg}{Degree of the B-splines (default is 3).}

\item{nknot}{Vector specifying the number of knots per column. Default is \code{rep(20, ncol(X))}.}

\item{reduce.knots}{Logical. Reduces knots to avoid constant columns if TRUE (default is FALSE).}
}
\value{
A list containing:
\describe{
\item{Z}{Design matrix for training data (B-spline coefficients).}
\item{Ztest}{Design matrix for test data.}
\item{sizeZ}{Vector of number of basis functions for each column.}
}
}
\description{
Transforms each column of a numeric matrix (or vector) into a new basis defined by B-spline functions.
}
\examples{
X <- matrix(rnorm(100), ncol = 5)
Xtest <- matrix(rnorm(300), ncol = 5)
result <- X2s(X, Xtest)

}
\references{
Kraemer, N., Boulesteix, A.-L., & Tutz, G. (2008). Penalized Partial Least Squares with Applications to B-Spline Transformations and Functional Data. \emph{Chemometrics and Intelligent Laboratory Systems}, 94, 60-69. https://doi.org/10.1016/j.chemolab.2008.06.009
}
