% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trendAnalysis.R
\name{change}
\alias{change}
\title{Compute the change in the population over a time interval.}
\usage{
change(trend, start, end, alpha = 0.05)
}
\arguments{
\item{trend}{A fitted object of class trend.}

\item{start}{Start time for the comparison.}

\item{end}{End time for the comparison.}

\item{alpha}{alpha-level for approximate confidence interval.}
}
\value{
A list containing the estimated change, and start and end points.
}
\description{
Computes the estimated percentual change in the population between two given time points, 
and an approximate confidence interval for the change.
}
\details{
The function computes the estimated change between two chosen time points. 
When random effects are present, the change is computed for the underlying linear or
smooth trend term. 
For index models, the change is estimated from the difference between indices.
Changes can only be computed between time points that were included in the \code{trendGrid}
argument to \link{ptrend}, if the two time points are not included the nearest points in the grid are chosen.

Confidence intervals are computed using quantiles of the bootstrapped trends.
}
\note{
If \code{start} or \code{end} are not contained in the \code{trendgrid} argument of the \code{\link{ptrend}} function, 
the change is computed between the values in the grid that are closest to these points.
}
\examples{
## Simulate a data set with 10 sites and 30 years
data = simTrend(30, 10)
## Fit a smooth trend with fixed site effects, random time effects,
## and automatic selection of degrees of freedom
trFit = ptrend(count ~ trend(year, type = "smooth") + site, data = data)
## Check the estimated percent change from year 2 to 20
change(trFit, 10, 20)
}
\author{
Jonas Knape
}
