% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmultinom.R
\name{invert.pmultinom}
\alias{invert.pmultinom}
\title{Calculate the sample size such that the probability of a result is a given amount.}
\usage{
invert.pmultinom(lower = -Inf, upper = Inf, probs, target.prob, method)
}
\arguments{
\item{lower}{Vector of lower bounds. Lower bounds are excluded}

\item{upper}{Vector of upper bounds. Upper bounds are included}

\item{probs}{Cell probabilities}

\item{target.prob}{The probability of the event, at the output sample size.}

\item{method}{Method used for computation. Only method currently implemented is "exact"}
}
\value{
The sample size parameter at which the the target probability of the given event is achieved.
}
\description{
Calculate the sample size such that the probability of a result is a given amount.
}
\details{
If only lower is given, then the result is the smallest size such that
pmultinom(lower=lower, size=size, probs=probs) >= target.prob. If only upper
is given, then the result is the smallest size such that
pmultinom(upper=upper, size=size, probs=probs) <= target.prob. Behavior when
both lower and upper are given is not yet implemented.
}
\examples{
# How many cells must be sequenced to have a 95\% chance of
# observing at least 2 from each subclone of a tumor? (Data
# from Casasent et al (2018); see vignette("pmultinom") for
# details of this example)

# Input: 
ncells <- 204
subclone.freqs <- c(43, 20, 82, 17, 5, 37)/ncells
target.number <- c(2, 2, 2, 2, 2, 0)
lower.bound <- target.number - 1
invert.pmultinom(lower=lower.bound, probs=subclone.freqs,
                 target.prob=.95, method="exact")
# Output:
# [1] 192

}
\references{
Casasent, A. K., Schalck, A., Gao, R., Sei, E., Long, A., Pangburn, W., ... & Navin, N. E. (2018). Multiclonal Invasion in Breast Tumors Identified by Topographic Single Cell Sequencing. Cell. doi:10.1016/j.cell.2017.12.007
}
\seealso{
\code{\link{pmultinom}}
}
