% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metar_decode.R
\name{metar_decode}
\alias{metar_decode}
\title{Decode METAR report.}
\usage{
metar_decode(
  x,
  metric = TRUE,
  altimeter = FALSE,
  numeric_only = FALSE,
  check = TRUE,
  sep = ";"
)
}
\arguments{
\item{x}{character vector; a single METAR weather report or\cr
historical METAR weather reports.}

\item{metric}{logical; if TRUE wind speeds returned in m/s, distances in meters.\cr
If FALSE, wind speeds returned in knots and distances in miles.}

\item{altimeter}{logical; if FLASE pressures returned in hPa, if TRUE in mmHg.}

\item{numeric_only}{logical; if TRUE only numeric values are returned.}

\item{check}{logical; if TRUE the syntax of METAR reports will be checked and incorrect
reports will be omitted. If FALSE, the incorrect syntax of reports can cause errors and
breakdown of decoding. The default value is TRUE.}

\item{sep}{character; comma or semicolon, used for separating decoded elements of weather
conditions information. The default value is ";".}
}
\value{
a tibble with decoded METAR weather report or reports.
}
\description{
Extract and parse information from a single METAR weather report or several reports.
}
\details{
Decoded METAR weather report consists of:\cr
\itemize{
\item Remark: Don't use for flight planning or navigation!
or Incorrect METAR report! Please check the column Original_METAR.
\item Airport ICAO
\item Day of Month
\item Hour (HH:mm)
\item Time zone
\item Wind speed
\item Wind speed unit (m/s or kn)
\item Gust
\item Gust unit (m/s or kn)
\item Wind shear
\item Wind direction (degrees)
\item Temperature (Celsius degrees)
\item Dew point (Celsius degrees)
\item Pressure (hPa)
\item Pressure unit (hPa or mmHg)
\item Visibility
\item Visibility unit (m or miles)
\item Cloud coverage
\item Weather conditions information from WX codes
\item Runway visibility (m or feet)
\item Airport Name
\item Longitude
\item Latitude
\item Elevation
\item Decode Date
\item Original METAR text
}
}
\examples{
metar_decode("EPWA 281830Z 18009KT 140V200 9999 SCT037 03/M01 Q1008 NOSIG")
metar_decode("CYUL 281800Z 13008KT 30SM BKN240 01/M06 A3005 RMK CI5 SLP180",
altimeter = TRUE, metric = FALSE)
metar_decode("201711271930 METAR LEMD 271930Z 02002KT CAVOK 04/M03 Q1025")
metar_decode("CYUL 281800Z 13008KT 30SM BKN240 01/M06 A3005", altimeter = TRUE)
metar_decode("CYWG 172000Z 30015G25KT 3/4SM R36/4000FT/D -SN M05/M08 A2992")
metar_decode("202103251800 METAR COR NFTL 251800Z 00000KT SCT017TCU BKN290 25/25 Q1014")

}
