% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_analysis.R
\name{perform_analysis}
\alias{perform_analysis}
\title{Internal function to perform LDSC heritability/covariance analysis - refer to ldscr R package (https://github.com/mglev1n/ldscr)}
\usage{
perform_analysis(n.blocks, n.snps, weighted.LD, weighted.chi, N.bar, m)
}
\arguments{
\item{n.blocks}{Number of blocks}

\item{n.snps}{Number of SNPs}

\item{weighted.LD}{wld score}

\item{weighted.chi}{chi-square}

\item{N.bar}{Average N after merging}

\item{m}{Number of SNPs from LD data}
}
\value{
A list containing the results of the LDSC heritability/covariance analysis with the following elements:
\itemize{
  \item \code{reg.tot}: Estimated total heritability or covariance (regression coefficient scaled by \code{m}).
  \item \code{tot.se}: Standard error of the total heritability/covariance estimate, computed using a block jackknife.
  \item \code{intercept}: LDSC regression intercept.
  \item \code{intercept.se}: Standard error of the intercept, estimated via block jackknife.
  \item \code{pseudo.values}: Vector of pseudo-values from the block jackknife procedure, one per block.
  \item \code{N.bar}: Average sample size across SNPs after merging.
}
}
\description{
`perform_analysis()` Internal function to perform LDSC heritability/covariance analysis
}
