% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sanitize_latex.R
\name{sanitize_latex}
\alias{sanitize_latex}
\title{Escape Characters for Printing in LaTeX Output}
\usage{
sanitize_latex(
  object,
  inn = NULL,
  out = NULL,
  pb = FALSE,
  greek = FALSE,
  na = "",
  ...
)
}
\arguments{
\item{object}{\code{character} vector of strings to translate.
Any NAs are set to blank strings before conversion.}

\item{inn}{\code{character} vector. Additional strings to translate.}

\item{out}{\code{character} vector the same length as \code{inn}.
This gives the translated value of the corresonding element in 
\code{inn}}

\item{pb}{\code{logical(1)} If \code{pb=TRUE}, \code{sanitize_latex} also 
translates \code{[()]} to math mode using \code{\\left}, \code{\\right}.}

\item{greek}{\code{logical(1)}. set to \code{TRUE} to have 
\code{sanitize_latex} put names for greek letters in math mode and 
add backslashes.}

\item{na}{\code{character(1)} Single character string to translate 
\code{NA} values to.}

\item{...}{Additional arguments for other methods. Currently ignored.}
}
\value{
Vector of chracter strings.
}
\description{
\code{sanitize_latex} translates particular items in 
character strings to LaTeX format, e.g., makes \code{a^2 = a\$^2\$} 
for superscript within variable labels. LaTeX names of greek letters 
(e.g., "alpha") will have backslashes added if \code{greek==TRUE}. 
Math mode is inserted as needed. \code{sanitize_latex} assumes that 
input text always has matches, e.g. \code{[) [] (] ()}, and that 
surrounding by \code{\$\$} is OK.
}
\examples{
sanitize_latex("75\% of the cars were | more than $20,000 Delta = 1.30", greek = TRUE)

}
\seealso{
\code{Hmisc::latexTranslate}, \code{Hmisc::sedit}
}
\author{
This code is lifted from the \code{Hmisc} package in order to 
avoid depending on that package.

Frank E. Harrell Jr.\cr
Department of Biostatistics,\cr
Vanderbilt University,\cr
f.harrell@vanderbilt.edu\cr

Richard M. Heiberger,\cr
Department of Statistics,\cr
Temple University, Philadelphia, PA.\cr
rmh@temple.edu\cr

David R. Whiting,\cr
School of Clinical Medical Sciences (Diabetes),\cr
University of Newcastle upon Tyne, UK.\cr
david.whiting@ncl.ac.uk\cr
}
