#' get_generic_list fetches all rows of a given api
#'
#' @param token  login token generated by \code{\link{get_login_token}}
#' @param offset defailt 0, integer, where to start fetching usergroups
#' @param api_endpoint string with api endpoint
#' @param columns vector of strings containing columnnames
#' @param datetime_columns vector of strings containing columnnames which are
#' converted to datetime
#'
#' @return data.frame
get_generic_list <- function(token, offset, api_endpoint, columns, datetime_columns) {

  get_generic_list_single <- function(token, offset = 0) {

    url <- paste0(token$url, api_endpoint)

    query <- list(
      offset = offset,
      limit  = MAX_LINES_PER_REQUEST_USERS_API()
    )

    result <- httr::GET(
      url = url,
      query = query,
      httr::add_headers(Authorization = paste0(token$token_type, " ",
                                               token$access_token)),
      httr::add_headers("Accept-Encoding" = "gzip, deflate"),
      httr::content_type("application/vnd.api+json")
    )

    if (httr::status_code(result) == 200) {
      json <- httr::content(result, "text", encoding = "utf8")

      from_json <- json %>% rjson::fromJSON(simplify = FALSE)
      meta <- from_json %>% extract2("meta")
      data <- from_json %>% extract2("data")

      if (length(data) > 0) {
        data <- data %>%  map_dfr(flatten)
      } else {
        data <- columns %>%
          purrr::map_dfc(setNames, object = list(character()))
      }
      return(list("data" = data, "meta" = meta))
    } else {
      warning(httr::content(result))
      return(NULL)
    }
  }

  result <- get_generic_list_single(token, offset)
  result_data <- result$data

  if ((result$meta$total > result$data %>% nrow() + offset) ) {
    next_offset <- offset + MAX_LINES_PER_REQUEST_USERS_API()
    next_result <- get_generic_list(token, next_offset, api_endpoint, columns,
                                    datetime_columns)
    result_data <- result_data %>% bind_rows(next_result)
  }
  result_data <- result_data %>%
    dplyr::mutate(
      dplyr::across(dplyr::all_of(datetime_columns), lubridate::ymd_hms)
    )
  return(result_data)
}
