% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdm.R
\name{sdm}
\alias{sdm}
\title{Fast species distribution model}
\usage{
sdm(
  x,
  layers = NULL,
  pol = NULL,
  thin = TRUE,
  thin.size = 500,
  algorithm = "all",
  size = 50,
  width = 50000,
  mask = FALSE,
  predictors,
  background = NULL
)
}
\arguments{
\item{x}{A dataframe containing the species occurrences
and geographic coordinates. Column 1 labeled as "species", column 2 "lon",
column 3 "lat".}

\item{layers}{A \code{SpatRaster} of predictor variables for fitting species
distribution models from species occurrences.}

\item{pol}{A vector polygon specifying the calibration area or boundary to 
account for a more realistic dispersal capacity and ecological limitation 
of a species. If \code{NULL}, the extent of input points is used.}

\item{thin}{Whether to spatially thin occurrences}

\item{thin.size}{The size of the thin occurrences.}

\item{algorithm}{Character. The choice of algorithm to run the species
distribution model. For now, the available algorithms include:
\itemize{
\item \dQuote{all}: Calls all available algorithms: both GLM and MAXENT.
\item \dQuote{GLM}: Calls only Generalized linear model.
\item \dQuote{MAXENT}: Calls only Maximum entropy.
}}

\item{size}{Minimum number of points required to successfully run
a species distribution model especially for species with few occurrences.}

\item{width}{Width of buffer in meter if x is in longitude/latitude CRS.}

\item{mask}{logical. Should \code{layers} be used to mask? Only used if 
\code{pol} is a SpatVector.}

\item{predictors}{If predicting to new time points, the climate layers for
the time points.}

\item{background}{A dataframe of background points, specifying 2 columns 
with long lat or x and y as nulls for species distribution modeling, often 
using a vector of probability weights.}
}
\value{
A list with the following objects:
\itemize{
  \item \code{ensemble_raster} The ensembled raster that predicts
  the potential species distribution based on the algorithms selected.
  \item \code{data} The dataframe of occurrences used to implement the model.
  \item \code{polygon} Map polygons of the predicted distributions
  analogous to extent-of-occurrence range polygon.
  \item \code{indiv_models} Raster layers for the separate models that
  predict the potential species distribution.
}
}
\description{
This function computes species distribution models using
two modelling algorithms: generalized linear models,
and maximum entropy (only if \code{rJava} is available).
Note: this is an experimental function, and may change in the future.
}
\examples{
\donttest{
# get predictor variables
library(predicts)
f <- system.file("ex/bio.tif", package="predicts")
preds <- rast(f)
#plot(preds)

# get species occurrences
b <- file.path(system.file(package="predicts"), "ex/bradypus.csv")
d <- read.csv(b)

# fit ensemble model for four algorithms
# m <- sdm(d, layers = preds, predictors = preds, algorithm = "all")
# plot(m$ensemble_raster)
# plot(m$polygon, add=TRUE)
}
}
\references{
Zurell, D., Franklin, J., König, C., Bouchet, P.J., Dormann, C.F., Elith, J.,
Fandos, G., Feng, X., Guillera‐Arroita, G., Guisan, A., Lahoz‐Monfort, J.J.,
Leitão, P.J., Park, D.S., Peterson, A.T., Rapacciuolo, G., Schmatz, D.R.,
Schröder, B., Serra‐Diaz, J.M., Thuiller, W., Yates, K.L., Zimmermann, N.E.
and Merow, C. (2020), A standard protocol for reporting species distribution
models. \emph{Ecography}, \strong{43}: 1261-1277.
}
