% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{sample_parameters_from_covariance_matrix}
\alias{sample_parameters_from_covariance_matrix}
\title{sample_parameters_from_covariance_matrix}
\usage{
sample_parameters_from_covariance_matrix(
  model,
  parameter_estimates,
  covariance_matrix,
  force_posdef_samples = NULL,
  force_posdef_covmatrix = FALSE,
  n = 1,
  seed = 1234
)
}
\arguments{
\item{model}{(Model) Input model}

\item{parameter_estimates}{(array) Parameter estimates to use as means in sampling}

\item{covariance_matrix}{(data.frame) Parameter uncertainty covariance matrix}

\item{force_posdef_samples}{(numeric (optional)) Set to how many iterations to do before forcing all samples to be positive definite. NULL is
default and means never and 0 means always}

\item{force_posdef_covmatrix}{(logical) Set to TRUE to force the input covariance matrix to be positive definite}

\item{n}{(numeric) Number of samples}

\item{seed}{(numeric) Random number generator}
}
\value{
(data.frame) A dataframe with one sample per row
}
\description{
Sample parameter vectors using the covariance matrix

If parameters is not provided all estimated parameters will be used
}
\examples{
\dontrun{
model <- load_example_model("pheno")
results <- load_example_modelfit_results("pheno")
rng <- create_rng(23)
cov <- results$covariance_matrix
pe <- results$parameter_estimates
sample_parameters_from_covariance_matrix(model, pe, cov, n=3, seed=rng)
}
}
\seealso{
sample_parameters_uniformly : Sample parameter vectors using uniform distribution

sample_individual_estimates : Sample individual estiates given their covariance
}
