#' responseReturn
#'
#' @param raw the chatresponse to return
#'
#' @importFrom clipr read_clip
#' @importFrom utils capture.output
#'
#' @return A character value with the response generated by Large Language Model.
#'
#'
responseReturn <- function(raw) {

    # format 'raw' data
    formatted <- capture.output(cat(raw))
    # write to the clipboard
    clipr::write_clip(formatted, allow_non_interactive = TRUE)

    return(formatted)

}

