% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{activateAmendments}
\alias{activateAmendments}
\alias{activateAmendments,Project,character-method}
\title{Activate amendments in objects of \code{"\linkS4class{Project}"}}
\usage{
activateAmendments(.Object, amendments)

\S4method{activateAmendments}{Project,character}(.Object, amendments)
}
\arguments{
\item{.Object}{an object of class \code{"\linkS4class{Project}"}}

\item{amendments}{character with the amendment name}
}
\value{
an object of class \code{"\linkS4class{Project}"} with activated amendments
}
\description{
This method switches between the amendments
within the \code{"\linkS4class{Project}"} object
}
\details{
To check what are the amendments names
call \code{listAmendments(p)}, where \code{p} is the object
of \code{"\linkS4class{Project}"} class
}
\section{Methods (by class)}{
\itemize{
\item \code{activateAmendments(.Object = Project, amendments = character)}: activate amendments in a \code{"\linkS4class{Project}"} object

}}
\examples{
projectConfig = system.file("extdata",
"example_peps-master",
"example_amendments1",
"project_config.yaml",
package = "pepr")
p = Project(file = projectConfig)
availAmendments = listAmendments(p)
activateAmendments(p, availAmendments[1])
}
