% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form-other.R
\name{form_recenter}
\alias{form_recenter}
\alias{form_respread}
\title{Change center and spread of distribution}
\usage{
form_recenter(f, to, method = "mean")

form_respread(f, to, method = "sd", center_method = "mean")
}
\arguments{
\item{f}{A pdqr-function.}

\item{to}{A desired value of summary.}

\item{method}{Method of computing center for \code{form_recenter()} and spread for
\code{form_respread()}. Values should be one of possible \code{method} values from
\code{\link[=summ_center]{summ_center()}} and \code{\link[=summ_spread]{summ_spread()}} respectively.}

\item{center_method}{Method of computing center for \code{form_respread()} in
order to preserve it in output.}
}
\value{
A pdqr-function describing distribution with desired center or
spread.
}
\description{
These functions implement linear transformations, output distribution of
which has desired \link[=summ_center]{center} and \link[=summ_spread]{spread}. These
functions are useful for creating distributions with some input center and
spread value based on present distribution, which is a common task during
hypothesis testing.
}
\details{
\code{form_recenter(f, to, method)} is basically a
\code{f - summ_center(f, method) + to}: it moves distribution without affecting
its shape so that output distribution has center at \code{to}.

\code{form_respread(f, to, method, center_method)} is a following linear
transformation: \code{coef * (f - center) + center}, where \code{center} is
\code{summ_center(f, center_method)} and \code{coef} is computed so as to guarantee
output distribution to have spread equal to \code{to}. In other words, this linear
transformation stretches distribution around its center until the result has
spread equal to \code{to} (center remains the same as in input \code{f}).
}
\examples{
my_beta <- as_d(dbeta, shape1 = 1, shape2 = 3)

my_beta2 <- form_recenter(my_beta, to = 2)
summ_center(my_beta2)

my_beta3 <- form_respread(my_beta2, to = 10, method = "range")
summ_spread(my_beta3, method = "range")
## Center remains unchainged
summ_center(my_beta3)
}
