% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_list_managed_rule_sets}
\alias{wafv2_list_managed_rule_sets}
\title{Retrieves the managed rule sets that you own}
\usage{
wafv2_list_managed_rule_sets(Scope, NextMarker = NULL, Limit = NULL)
}
\arguments{
\item{Scope}{[required] Specifies whether this is for a global resource type, such as a Amazon
CloudFront distribution.

To work with CloudFront, you must also specify the Region US East (N.
Virginia) as follows:
\itemize{
\item CLI - Specify the Region when you use the CloudFront scope:
\code{--scope=CLOUDFRONT --region=us-east-1}.
\item API and SDKs - For all calls, use the Region endpoint us-east-1.
}}

\item{NextMarker}{When you request a list of objects with a \code{Limit} setting, if the number
of objects that are still available for retrieval exceeds the limit, WAF
returns a \code{NextMarker} value in the response. To retrieve the next batch
of objects, provide the marker from the prior call in your next request.}

\item{Limit}{The maximum number of objects that you want WAF to return for this
request. If more objects are available, in the response, WAF provides a
\code{NextMarker} value that you can use in a subsequent call to get the next
batch of objects.}
}
\description{
Retrieves the managed rule sets that you own.

See \url{https://www.paws-r-sdk.com/docs/wafv2_list_managed_rule_sets/} for full documentation.
}
\keyword{internal}
