% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trap_force.R
\docType{data}
\name{trap_force}
\alias{trap_force}
\title{Attract and trap particles within polygons}
\description{
This force creates a trap based on any type of polygon that attracts
particles as long as they are outside the polygon, while leaving particles
inside the polygon unaffected. The trap as such has no walls and particles
are allowed to leave it, but they will be pulled back as soon as they exits
the polygon.
}
\section{Training parameters}{

The following parameters defines the training of the force and can be passed
along a call to \code{\link[=wield]{wield()}}
\itemize{
\item \code{polygon} : A two column matrix giving the corners of the polygon, or a
list of matrices to use multiple polygons. If multiple polygons are
overlapping it is considered a hole.
\item \code{strength} : The attractive force applied to the particle. Particles are
attracted towards the closest part of the polygon, rather than the center,
and the attraction is stronger for particles moving away from the polygon
than for those moving towards it. (\emph{tidy eval})
\item \code{min_dist} : A lower distance threshold below which the strength is not
increased. The attraction of the trap falls of with the square of the
distance to the particle, so particles close by can get an enormous
attraction unless this threshold is set (so much that the shoot out of the
other side of the trap).
\item \code{distance_falloff} : How should the attractive force deteriorate with the
distance between the polygon and the particle. Defaults to 2 (quadratic
falloff) (\emph{tidy eval})
}
}

\seealso{
Other forces: 
\code{\link{center_force}},
\code{\link{collision_force}},
\code{\link{field_force}},
\code{\link{link_force}},
\code{\link{manybody_force}},
\code{\link{map_force}},
\code{\link{mean_force}},
\code{\link{random_force}},
\code{\link{reset_force}},
\code{\link{x_force}},
\code{\link{y_force}}
}
\concept{forces}
\keyword{datasets}
