% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficient_forestplot.R
\name{coefficient_forestplot}
\alias{coefficient_forestplot}
\title{Create forest plot of model coefficients with confidence intervals}
\usage{
coefficient_forestplot(
  model_list,
  model_names = NULL,
  conflevel = 0.95,
  horiz = TRUE
)
}
\arguments{
\item{model_list}{A list of regression models.}

\item{model_names}{A list of names for the regression models.}

\item{conflevel}{Confidence level for intervals.}

\item{horiz}{Toggle whether confidence intervals are displayed horizontally or
vertically. Default is set to \code{TRUE}.}
}
\value{
A ggplot object to compare model coefficient estimates with their
 corresponding confidence interval(s), grouped by coefficient.
}
\description{
Create a ggplot forest plot of model coefficients with confidence intervals.
}
\details{
The forest plot groups variables along the axis determined by the \code{horiz}
parameter and colors the data by model. If \code{model_names = NULL}, the
default, models are numbered sequentially in the order they appear in
\code{model_list} (Model 1, Model 2, Model 3, etc.).
}
\examples{
 states = as.data.frame(state.x77)

 m1 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='Northeast')
 m2 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='South')
 m3 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='North Central')
 m4 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='West')

 mList = list(m1, m2, m3, m4)

 coefficient_forestplot(model_list = mList,
                        model_names =c('Northeast', 'South',
                                       'North Central', 'West'),
                        horiz = FALSE)

}
