% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pokedex.R
\name{pokedex}
\alias{pokedex}
\title{Display pokemon palettes.}
\usage{
pokedex(pokemon = NULL, spread = NULL, cb = NULL)
}
\arguments{
\item{pokemon}{An integer or character pokemon name}

\item{spread}{How many, quite distinct, colours should be returned. See details.}

\item{cb}{A number between 1 and 4 to select ten of 40 colourblind friendly 
(Deuteranomaly) palettes. \code{pokemon} is ignored if used, but \code{spread}
works as normal.}
}
\description{
Display 10 pokemon palettes starting from a name or number.
If no name or number is given, 10 of the better palettes are
displayed. Pokedex is a Trademark of Nintendo.
}
\details{
If \code{spread} is given an integer, the full palette is 
 clustered into that many groups (ward clustering in HSV space). 
 The most common colour in each cluster is then returned. It is
 hoped this will give a good balance between reflecting the pokemons
 colouring while giving relatively distinct colours.

 Thanks to Luis Verde for the colourblind suitable selection.
}
\examples{
pokedex()
pokedex('Metapod')
pokedex(5, spread = 2)
pokedex(cb = 3)
pokedex(cb = 2, spread = 6)
}

