% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options_get.R
\name{opt}
\alias{opt}
\alias{opt_set}
\alias{opt<-}
\alias{opt_source}
\alias{opts}
\alias{opt_set_local}
\alias{opts_list}
\title{Inspecting Option Values}
\usage{
opt(x, default, env = parent.frame(), ...)

opt_set(x, value, env = parent.frame(), ...)

opt(x, ...) <- value

opt_source(x, env = parent.frame())

opts(xs = NULL, env = parent.frame())

opt_set_local(
  x,
  value,
  env = parent.frame(),
  ...,
  add = TRUE,
  after = FALSE,
  scope = parent.frame()
)

opts_list(
  ...,
  env = parent.frame(),
  check_names = c("asis", "warn", "error"),
  opts = list(...)
)
}
\arguments{
\item{x, xs}{An option name, vector of option names, or a named list of new
option values}

\item{default}{A default value if the option is not set}

\item{env}{An environment, namespace or package name to pull options from}

\item{...}{See specific functions to see behavior.}

\item{value}{A new value to update the associated global option}

\item{add, after, scope}{Passed to \link{on.exit}, with alternative defaults.
\code{scope} is passed to the \link{on.exit} \code{envir} parameter to disambiguate it
from \code{env}.}

\item{check_names}{(experimental) A behavior used when checking option
names against specified options. Expects one of \code{"asis"}, \code{"warn"} or
\code{"stop"}.}

\item{opts}{A \code{list} of values, for use in functions that accept \code{...}
arguments. In rare cases where your argument names conflict with other
named arguments to these functions, you can specify them directly using
this parameter.}
}
\value{
For \code{opt()} and \code{opts()}; the result of the option (or a list of
results), either the value from a global option, the result of processing
the environment variable or the default value, depending on which of the
alternative sources are defined.

For modifying functions (\link{opt_set} and \link{opt<-}: the value of the
option prior to modification

For \link{opt_source}; the source that is used for a specific option,
one of \code{"option"}, \code{"envvar"} or \code{"default"}.
}
\description{
Inspecting Option Values
}
\section{Functions}{
\itemize{
\item \code{opt()}: Retrieve an option. Additional \code{...} arguments passed to an optional
\code{option_fn}. See \code{\link[=option_spec]{option_spec()}} for details.

\item \code{opt_set()}: Set an option's value. Additional \code{...} arguments passed to
\code{\link[=get_option_spec]{get_option_spec()}}.

\item \code{opt(x, ...) <- value}: An alias for \code{\link[=opt_set]{opt_set()}}

\item \code{opt_source()}: Determine source of option value. Primarily used for diagnosing options
behaviors.

\item \code{opts()}: Retrieve multiple options. When no names are provided, return a list
containing all options from a given environment. Accepts a character
vector of option names or a named list of new values to modify global
option values.

\item \code{opt_set_local()}: Set an option only in the local frame. Additional \code{...} arguments passed to
\code{\link[=on.exit]{on.exit()}}.

\item \code{opts_list()}: Produce a named list of namespaced option values, for use with \code{\link[=options]{options()}}
and \code{\link[withr]{withr}}. Additional \code{...} arguments used to provide
named option values.

}}
\note{
Local options are set with \link{on.exit}, which can be prone to error if
subsequent calls are not called with \code{add = TRUE} (masking existing
\link{on.exit} callbacks). A more rigorous alternative might make use of
\code{\link[withr:defer]{withr::defer}}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{old <- opt_set("option", value)
withr::defer(opt_set("option", old))
}\if{html}{\out{</div>}}

If you'd prefer to use this style, see \code{\link[=opts_list]{opts_list()}}, which is designed
to work nicely with \code{\link[withr]{withr}}.
}
\examples{
define_options("Whether execution should emit console output", quiet = FALSE)
opt("quiet")

define_options("Whether execution should emit console output", quiet = FALSE)
opt_source("quiet")

Sys.setenv(R_GLOBALENV_QUIET = TRUE)
opt_source("quiet")

options(globalenv.quiet = FALSE)
opt_source("quiet")

define_options("Quietly", quiet = TRUE, "Verbosity", verbose = FALSE)

# retrieve multiple options
opts(c("quiet", "verbose"))

# update multiple options, returns unmodified values
opts(list(quiet = 42, verbose = TRUE))

# next time we check their values we'll see the modified values
opts(c("quiet", "verbose"))

define_options("print quietly", quiet = TRUE)

print.example <- function(x, ...) if (!opt("quiet")) NextMethod()
example <- structure("Hello, World!", class = "example")
print(example)

# using base R options to manage temporary options
orig_opts <- options(opts_list(quiet = FALSE))
print(example)
options(orig_opts)

\dontshow{if (length(find.package("withr")) > 0L) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# using `withr` to manage temporary options
withr::with_options(opts_list(quiet = FALSE), print(example))
\dontshow{\}) # examplesIf}
}
