% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08-report.R
\name{report_op_table}
\alias{report_op_table}
\alias{report_op_demo}
\alias{report_op_food}
\alias{report_op_hunger}
\alias{report_op_disability}
\alias{report_op_adl}
\alias{report_op_mental}
\alias{report_op_dementia}
\alias{report_op_health}
\alias{report_op_oedema}
\alias{report_op_anthro}
\alias{report_op_screen}
\alias{report_op_visual}
\alias{report_op_income}
\alias{report_op_wash}
\alias{report_op_misc}
\title{Create table and report chunk of RAM-OP results}
\usage{
report_op_table(estimates, filename = paste(tempdir(), "ramOP", sep = "/"))

report_op_demo(output_format = c("html", "docx", "odt", "pdf"))

report_op_food(output_format = c("html", "docx", "odt", "pdf"))

report_op_hunger(output_format = c("html", "docx", "odt", "pdf"))

report_op_disability(output_format = c("html", "docx", "odt", "pdf"))

report_op_adl(output_format = c("html", "docx", "odt", "pdf"))

report_op_mental(output_format = c("html", "docx", "odt", "pdf"))

report_op_dementia(output_format = c("html", "docx", "odt", "pdf"))

report_op_health(output_format = c("html", "docx", "odt", "pdf"))

report_op_oedema(output_format = c("html", "docx", "odt", "pdf"))

report_op_anthro(output_format = c("html", "docx", "odt", "pdf"))

report_op_screen(output_format = c("html", "docx", "odt", "pdf"))

report_op_visual(output_format = c("html", "docx", "odt", "pdf"))

report_op_income(output_format = c("html", "docx", "odt", "pdf"))

report_op_wash(output_format = c("html", "docx", "odt", "pdf"))

report_op_misc(output_format = c("html", "docx", "odt", "pdf"))
}
\arguments{
\item{estimates}{A data.frame of RAM-OP results produced by \code{\link[=merge_op]{merge_op()}}.}

\item{filename}{Prefix to append to report output filename. Can be specified
as a path to a specific directory where to output tabular results CSV file.
Defaults to a path to a temporary directory with a filename starting with
\emph{ramOP}.}

\item{output_format}{Either \emph{"html"}, \emph{"docx"}, \emph{"odt"}, or \emph{"pdf"}. Defaults
to \emph{"html"}.}
}
\value{
Report of tabulated estimated results saved in CSV format in current
working directory or in the specified path or a reporting chunk for
specific indicators.
}
\description{
Create table and report chunk of RAM-OP results
}
\examples{
##
x <- estimate_classic(
  x = create_op(testSVY), w = testPSU, replicates = 9
)

y <- estimate_probit(
  x = create_op(testSVY), w = testPSU, replicates = 9
)

z <- merge_op(x, y, prop2percent = TRUE)
report_op_table(z)

report_op_demo()
report_op_hunger()
report_op_food()
report_op_disability()

}
\author{
Mark Myatt and Ernest Guevarra
}
