% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ob-analytics.R
\docType{data}
\name{trades}
\alias{trades}
\title{Trades.}
\format{A data.frame consisting of the following fields:
\describe{
  \item{timestamp}{Local event timestamp.}
  \item{price}{Price at which the trade occured.}
  \item{volume}{Amount of traded volume.}
  \item{direction}{The trade direction: \emph{buy} or \emph{sell}.}
  \item{maker.event.id}{Corresponding market \emph{making} event id in
\code{\link{events}}.}
  \item{taker.event.id}{Corresponding market \emph{taking} event id in
\code{\link{events}}.}
  \item{maker}{Id of the market \emph{making} limit order in
\code{\link{events}}.}
  \item{taker}{Id of the market \emph{taking} limit order in
\code{\link{events}}.}
}}
\description{
Inferred trades (executions).
}
\details{
The trades data.frame contains a log of all executions ordered by local
timestamp. In addition to the usual timestamp, price and volume information,
each row also contains the trade direction (buyer or seller initiated) and
maker/taker limit order ids. The maker/taker event and limit order ids can
be used to group trades into market impacts. See:
\code{\link{tradeImpacts}}.
}
\author{
phil
}
\seealso{
Other Limit.order.book.data: \code{\link{depth.summary}},
  \code{\link{depth}}, \code{\link{events}}
}
\keyword{datasets}

