% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pointsOnBoxplot.R
\name{pointsOnBoxplot.default}
\alias{pointsOnBoxplot.default}
\title{Draw Points on Top of a Boxplot using Appropriate Shifting}
\usage{
\method{pointsOnBoxplot}{default}(x = NULL, y = NULL, totalSpread = 0.3,
  roundTo = NULL, horizontal = FALSE, ...)
}
\arguments{
\item{x}{vector of numeric values that were used to create boxplots}

\item{y}{vector of values representing a categorical variable}

\item{totalSpread}{total spread of point plotting range within a boxplot. Defaults to 0.3 so that points plot between 0.85 and 1.15}

\item{roundTo}{optional rounding interval. For example, if given roundTo = 0.25, all numeric x values will be rounded to the nearest quarter}

\item{horizontal}{logical indicating if the boxplots should be horizontal; default FALSE means vertical boxes.}

\item{...}{further parameters to be passed to the points function}
}
\value{
points are drawn to the current device
}
\description{
Draw Points on Top of a Boxplot using Appropriate Shifting
}
\examples{
# Examples run in the formula and default methods
x2 <- runif(50, 0, 10);
table(customRound(x2, roundTo = 0.5))
boxplot(x2)
pointsOnBoxplot(x2, pch = 19, roundTo = 0.5)

# Set up input data
x <- c(sample(1:5, size = 25, replace = TRUE), rpois(25, lambda = 4))
colVec <- c(rep("olivedrab", 10), rep("red", 5), rep("goldenrod", 15),
    rep("red", 15), rep("olivedrab", 5))
y <- rep(c("Awesome Rats", "Stupid Rats"), each = 25)
y2 <- rep(c("Open", "Analytics"), 25)

x2 <- c(1, 2, 2, 3, 3, 1, 1, 1, 4, 5)
y3 <- c(rep("A", 5), rep("B", 5))
levels(y3) <- c("A", "B", "C")

boxplot(x ~ y, horizontal = TRUE)
pointsOnBoxplot(x ~ y, horizontal = TRUE)

boxplot(x ~ y)
pointsOnBoxplot(x = x, y = y, col = colVec, pch = 19, cex = 2)

boxplot(x ~ y + y2)
pointsOnBoxplot(x ~ y + y2, col = colVec, pch = 19, cex = 2)
}
\author{
Jason Waddell
}

