% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/splitDensity.R
\name{drawSplitDensity}
\alias{drawSplitDensity}
\title{Draw a Split Density Plot}
\usage{
drawSplitDensity(x = NULL, y = NULL, densityObj = NULL, yshift = 0,
  colVec, outerCol, lwd = 2, split = NULL, yScale = NULL,
  fillBackground = FALSE)
}
\arguments{
\item{x}{x vector from a density object. e.g. data <- rnorm(100); x <- density(data)$x}

\item{y}{y vector from a density object}

\item{densityObj}{an object created by the function density()}

\item{yshift}{vertical shift to be applied to the y object}

\item{colVec}{color vector for the shaded regions that compose the interior of the plot.
The length of 'colVec' should be one greater than the length of split}

\item{outerCol}{the color for the outer density line}

\item{lwd}{line width for the outer density line}

\item{split}{vector of x values at which to split the density plot}

\item{yScale}{vertical scale at which to plot the density. For example, a call with 'yScale = 1' will
produce a density curve scaled between 0 and 1}

\item{fillBackground}{binary specification of whether to fill in the background the outerCol color}
}
\value{
none. Graph is plotted to the current device
}
\description{
Draw a Split Density Plot
}
\examples{
library(RColorBrewer)
data <- rnorm(1000)
x <- density(data)$x
y <- density(data)$y
colVec <- brewer.pal(9, "Blues")[3:8]
outerCol <- brewer.pal(9, "Blues")[9]

oaTemplate(xlim = range(x), ylim = c(0, 1), ygrid = 0, cex.axis = 1.2)
drawSplitDensity(x, y, colVec = colVec, split = c(-8),
		outerCol = outerCol,
		yScale = 0.95, yshift = 0)
}
\author{
Jason Waddell
}

