% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLayers.R
\name{getLayers}
\alias{getLayers}
\title{Gets a list of layer definitions}
\usage{
getLayers(labbcat.url)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}
}
\value{
A list of layer definitions, with members:
\itemize{
\item \emph{id} The layer's unique ID
\item \emph{parentId} The layer's parent layer ID
\item \emph{description} The description of the layer
\item \emph{alignment} The layer's alignment - 0 for none, 1 for point alignment, 2 for interval alignment
\item \emph{peers} Whether children have peers or not
\item \emph{peersOverlap} Whether child peers can overlap or not
\item \emph{parentIncludes} Whether the parent t-includes the child
\item \emph{saturated} Whether children must temporally fill the entire parent duration (true) or not (false)
\item \emph{parentIncludes} Whether the parent t-includes the child
\item \emph{type} The type for labels on this layer
\item \emph{validLabels} List of valid label values for this layer
}
}
\description{
Gets a list of layer definitions
}
\examples{
\dontrun{
## Get definitions of all layers
layers <- getLayers("https://labbcat.canterbury.ac.nz/demo/")
}

}
\seealso{
Other Annotation layer functions: 
\code{\link{deleteLayer}()},
\code{\link{generateLayer}()},
\code{\link{getLayer}()},
\code{\link{getLayerIds}()},
\code{\link{newLayer}()},
\code{\link{saveLayer}()}
}
\concept{Annotation layer functions}
\keyword{layer}
