% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_variance_method.R
\name{get_variance_method}
\alias{get_variance_method}
\title{Summarize the variance estimation method for the survey design}
\usage{
get_variance_method(survey_design)
}
\arguments{
\item{survey_design}{A survey design object created with the \code{survey} package.}
}
\value{
A text string describing the method used for variance estimation
}
\description{
Summarize the variance estimation method for the survey design
}
\details{
For replicate designs, the type of replicates will be determined
based on the \code{'type'} element of the survey design object.
If \code{type = 'bootstrap'}, this can correspond to any of various
types of bootstrap replication (Canty-Davison bootstrap, Rao-Wu's (n-1) bootstrap, etc.).

For designs which use linearization-based variance estimation, the summary
only indicates that linearization is used for variance estimation and, if a special
method is used for PPS variance estimation (e.g. Overton's approximation),
that PPS variance estimation method will be described.
}
\keyword{internal}
