% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-cureHR.R
\name{cureHR}
\alias{cureHR}
\title{Control hazard and hazard ratio generation function}
\usage{
cureHR(pi0, pi1 = NULL, k0, lmd0, theta, HRType, tchg = NULL)
}
\arguments{
\item{pi0}{cure rate for the control group}

\item{pi1}{cure rate for the treatment group, Default: NULL}

\item{k0}{shape parameter of the Weibull distribution for the control group}

\item{lmd0}{rate parameter of the Weibull distribution for the control group}

\item{theta}{hazard ratio function}

\item{HRType}{hazard ratio function type. \code{susceptible} indicates the hazard
ratio function applies to the susceptible only; \code{overall} indicates the hazard
ratio function applies to the overall population; \code{delayed} indicates a cure model
with delayed treatment effects. See details.}

\item{tchg}{delayed timepoint for \code{HRType} = \code{delayed}, Default: NULL}
}
\value{
a list of components including
\item{ctrl_hr}{a hazard function for the control group}
\item{hr}{a hazard ratio function}
}
\description{
Generate control hazard and hazard ratio function used for sample size calculation for cure model
}
\details{
DETAILS
The control group has a survival function of \eqn{S_o0=\pi_0+(1-\pi_0)S_0},where
\eqn{\pi_0} is the cure rate and \eqn{S_0} is the survival function for the susceptible
population. For \code{HRType} = \code{susceptible}, the user also needs to provide
the cure rate for the experimental group. The provided hazard ratio applies to the susceptible
population only. The returned hazard ratio function is the overall one. For \code{HRType}=\code{delayed},
the returned hazard ratio is derived based on the paper of Wei and Wu (2020) .
}
\examples{
p0 <- 0.2; p1 <- 0.3; param <- c(1, log(2)/12);
theta_eg <-function(t){t^0*0.7}
fit <- cureHR(p0, p1, param[1], param[2],theta_eg, HRType="susceptible")
# with delayed effects
theta_eg2 <- function(t){(t<=9)+(t>9)*0.7}
fit2 <- cureHR(p0, p1, param[1], param[2],theta_eg2, HRType="delayed", tchg=9)
}
\references{
Wei, J. and Wu, J., 2020. Cancer immunotherapy trial design with
cure rate and delayed treatment effect. Statistics in medicine, 39(6), pp.698-708.
}
\seealso{
\code{\link[stats]{integrate}}
}
