% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nndiagram.R
\name{nndiagram}
\alias{nndiagram}
\title{Producing 'LaTeX' Code for Drawing Neural Network Diagrams}
\usage{
nndiagram(
  input,
  hidden,
  keep = NULL,
  omit = NULL,
  title = NULL,
  color = "black",
  alpha = 1,
  layer.sep = 2.5,
  layer.label = NULL,
  input.label = NULL,
  output.label = NULL,
  suppress = FALSE
)
}
\arguments{
\item{input}{a positive integer that specifies the number of input neurons.}

\item{hidden}{a positive integer vector that specifies the number of neurons on each hidden layer. For example, c(4,4,4) specifies that there are 3 hidden layers and 4 neurons on each hidden layer.
Non-positive and non-integer numbers are not allowed.}

\item{keep}{an optional character vector that specifies the connections of neurons to be kept. For example, c("1->4","5->8") specifies the connections from neuron 1 to 4 and from neuron 5 to 8. Neurons are counted from
top to bottom and from left to right. As special cases, "->4" specifies all connections with neuron 4 as destination, and "5->" specifies all connections with neuron 5 as source. No space in the string is allowed. Default is \code{NULL}.}

\item{omit}{an optional character vector that specifies the connections of neurons to be omitted. The specification of connections is the same as that in 'keep'. However, users are not allowed to assign values to 'keep'
and 'omit' simultaneously. Default is \code{NULL}.}

\item{title}{an optional character that specifies the main title of diagram. Default is \code{NULL}.}

\item{color}{an optional character that specifies the color of lines. Default is \code{"black"}.}

\item{alpha}{an optional numeric value between 0 and 1 that specifies the opacity of lines. \code{1} indicates lines to be opaque, and \code{0} indicates lines to be transparent. Default is \code{1}.}

\item{layer.sep}{an optional positive numeric value that specifies the distance between layers of a neural network. Default is \code{2.5}.}

\item{layer.label}{an optional character vector that specifies label for each layer, including input, hidden and output layers.}

\item{input.label}{an optional character vector that specifies label for each input neuron.}

\item{output.label}{an optional character that specifies label for output neuron.}

\item{suppress}{an optional logical value that specifies whether \code{nndiagram} should suppress the output of 'LaTeX' code to be directly printed on console. Default is \code{FALSE}.}
}
\value{
\code{nndiagram} uses \code{cat()} to print out 'LaTeX' code on console, if not suppressed. Also, \code{nndiagram} saves the same output as a character vector invisibly, so users could use \code{cat()} to print it out later at their demand, as shown in Examples.
The \code{nndiagram} 'LaTeX' output can be directly copied and pasted to produce neural network diagram in any 'LaTeX' editor.
}
\description{
The \code{nndiagram} command is used to produce 'LaTeX' code for drawing well-formatted neural network diagrams. To make the code work in a 'LaTeX' editor, users need
to install and import two 'TeX' packages, i.e., \href{https://www.overleaf.com/learn/latex/TikZ_package}{TikZ} and
\href{https://www.ctan.org/pkg/ifthen#:~:text=Ifthen\%20is\%20a\%20separate\%20package\%20within\%20the\%20LaT.,always\%20needed\%20to\%20load\%20it.\%20Sources.\%20\%2Fmacros\%2Flatex\%2Fbase.\%20Documentation.}{ifthen}
in the setting of 'TeX' file. Syntax of importing these packages is included in the output of function.
}
\note{
This package is an ongoing project, and more functions will be added in the future, such as those to produce pdf version of diagrams or convert handdrawing neural network diagrams to computerized ones. Collaborations
are sincerely welcome. Comments and suggestions are always highly appreciated.
}
\examples{
# A neural network with 3 neurons on input layer, 4 neurons on each of 3 hidden layers,
# and 1 neuron on output layer. No connection is omitted and all other arguments are default.
nndiagram(input=3, hidden=c(4,4,4))

# Same as the first example but connections from neuron 1 to 4 and from neuron 5 to 8 are omitted.
nndiagram(input=3, hidden=c(4,4,4), omit=c("1->4","5->8"))

# Same as the first example but connections with neuron 4 as destination are omitted.
nndiagram(input=3, hidden=c(4,4,4), omit=c("->4"))

# Same as the first example but connections with neuron 5 as source are omitted.
nndiagram(input=3, hidden=c(4,4,4), omit=c("5->"))

# Suppress the output of 'LaTeX' code to be directly printed on the console and save the output
# to an object, which can be printed later at demand.
nnd <- nndiagram(input=3, hidden=c(4,4,4), suppress=TRUE)
cat(paste(nnd,"\n"))
}
\seealso{
\link{nndiagram_oversize}; \link{nndiagram_nodeCoverup}; \link{activation_curve}.
}
\author{
Chencheng Fang, Bonn Graduate School of Economics, University of Bonn. Email: \email{ccfang@uni-bonn.de}
}
